# REVIVEEDIT: ROBUST SEQUENTIAL EDITING VIA DOMINANT SUBSPACE PRESERVATION

This repository provides a **minimal example** implementation of **REVIVE**, our proposed plugin-style extension to Locate-then-Edit Knowledge Editing Methods.  
The code here is intended as supplementary material and can be easily plugged into the open-source implementations of MEMIT and AlphaEdit

---

## Key Functions

### `apply_memit_to_model`
- Standard MEMIT update function.
- Directly applies the computed key/value update matrices (`deltas`) to model weights.
- Provides a baseline implementation for knowledge editing.

### `apply_MEMIT_REVIVE_to_model`
- Our **proposed method (REVIVE)**.
- Adds a **projection step** on the update matrix to **safely filter directions** that may interfere with existing model knowledge.
- Controlled by a user-defined **threshold parameter (`thresh`)**, allowing flexible trade-offs between editing strength and knowledge preservation.
- Designed as a **drop-in replacement** for `apply_memit_to_model` — simply swap the function call.
- Requires no change to the MEMIT pipeline, making it a **lightweight plugin** that improves robustness.
- The project function defined in func:apply_MEMIT_REVIVE_to_model is the plug-and-play module that we proposed
---

## Practical Notes
- The provided code is a **standalone example** and can be directly integrated into the Existing framework.
- For full training and evaluation pipelines, please refer to AlphaEdit or MEMIT ’s official repository.
- Dependencies are consistent with MEMIT/AlphaEdit .

---

## Summary
**REVIVE** maintains the efficiency and simplicity of Knowledge Editing while offering a **plugin mechanism** for safer and more reliable model editing. By inserting a low-rank projection on the update matrix, our approach reduces interference and enhances stability during large-scale edits.
